<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('transaction_comments')) {
            Schema::create('transaction_comments', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('transaction_id')->index();
                $table->unsignedInteger('user_id')->index();
                $table->string('user_first_name')->nullable();
                $table->string('user_role')->nullable();
                $table->text('comment');
                $table->timestamps();

                // Keep FK when creating fresh and column sizes match
                $table->foreign('transaction_id')->references('id')->on('transactions')->onDelete('cascade');
            });
        } else {
            // Table already exists (likely from a previous partial run). Ensure required columns exist.
            Schema::table('transaction_comments', function (Blueprint $table) {
                if (!Schema::hasColumn('transaction_comments', 'user_first_name')) {
                    $table->string('user_first_name')->nullable()->after('user_id');
                }
                if (!Schema::hasColumn('transaction_comments', 'user_role')) {
                    $table->string('user_role')->nullable()->after('user_first_name');
                }
                if (!Schema::hasColumn('transaction_comments', 'comment')) {
                    $table->text('comment')->after('user_role');
                }
                if (!Schema::hasColumn('transaction_comments', 'created_at')) {
                    $table->timestamps();
                }
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('transaction_comments');
    }
};
